<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PropertyLanguage extends Model 
{

    protected $table = 'lim_property_languages';
    public $timestamps = true;
    protected $fillable = array('lim_language_id', 'lim_property_id', 'name', 'content');
    protected $visible = array('lim_language_id', 'lim_property_id', 'name', 'content');

    public function language()
    {
        return $this->belongsTo('App\Models\Language', 'lim_language_id');
    }

    public function property()
    {
        return $this->belongsTo('App\Models\Property', 'lim_property_id');
    }

}